import hxvlc.flixel.FlxVideoSprite;

camBF = new FlxCamera(0, 0, 960, 720);
camBF.bgColor = 0;
var devMode:Bool = false;

/** Opponent's original Y position */
var ogDADY = dad.y;

/** Player's original Y position */
var ogBFY = boyfriend.y;

if (FlxG.save.data.midsongvids_toggle) {
	var intro = new FlxVideoSprite(0, 0);
	intro.autoPause = false;
	intro.load(Assets.getPath(Paths.video("feshintro")));
	intro.visible = false;
	var energy = new FlxSprite(0, 0).loadGraphic(Paths.image("stages/blair/5hourenergy"));

	energy.visible = false;
}
function create() {
	PlayState.instance.introLength = 1;
	FlxG.cameras.remove(camHUD, false);
	FlxG.cameras.add(camBF, false);
	FlxG.cameras.add(camHUD, false);
	boyfriend.cameras = [camBF];
	GameOverSubstate.script = 'data/scripts/gameovers/bltears';
}

function onCountdown(event:CountdownEvent) {
	event.cancel();
}

function postCreate() {
	if (!devMode) {
		stage.getSprite("watermark").alpha = 0.001;
		camGame.visible = false;
		camHUD.alpha = 0.001;
		boyfriend.alpha = 0.001;
	}
	if (FlxG.save.data.midsongvids_toggle) {
		intro.bitmap.onFormatSetup.add(function() {
			intro.cameras = [camHUD2];
			intro.scale.set(1.5, 1.5);
			intro.updateHitbox();
		});

		energy.cameras = [camHUD2];
		energy.scale.set(1.8, 1.8);
		energy.screenCenter();

		add(intro);
		add(energy);
	}
}

var charBop = false;

function beatHit(beat) {
	if (charBop) {
		strumLines.members[0].characters[0].y += 40;
		strumLines.members[0].characters[1].y += 40;
		boyfriend.y += 40;
	}
}

/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
var videosToHandle:Array<FlxVideoSprite> = [intro];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}

function stepHit(step) {
	switch (step) {
		case 0:
			if (FlxG.save.data.midsongvids_toggle && !devMode) {
				intro.play();
				intro.visible = true;
			}
		case 64:
			FlxTween.tween(stage.getSprite("watermark"), {alpha: 0.8}, 1);
		case 96:
			if (FlxG.save.data.midsongvids_toggle)
				FlxTween.tween(intro, {alpha: 0.001}, (Conductor.stepCrochet / 1000) * 16);
		case 106:
			if (!devMode) {
				camGame.fade(FlxColor.BLACK, 0.9, true);
				camGame.scroll.x = 200;
				camGame.angle = -3;
				camGame.visible = true;
				FlxTween.tween(camGame.scroll, {x: 0}, (Conductor.stepCrochet / 1000) * 24, {ease: FlxEase.sineOut});
				FlxTween.tween(camGame, {angle: 0}, 2.5, {ease: FlxEase.sineOut});
			}
		case 112:
			if (FlxG.save.data.midsongvids_toggle && !devMode)
				intro.visible = false;
		case 128:
			FlxTween.tween(camHUD, {alpha: 1}, 1);
			FlxTween.tween(boyfriend, {alpha: 1}, 1);
		case 384:
			camGame.scroll.y -= 70;
			camBF.scroll.y += 80;
			camGame.scroll.x += 250;
			camBF.scroll.x -= 100;
			boyfriend.alpha = 0.001;
			FlxTween.tween(camGame.scroll, {x: -200}, (Conductor.stepCrochet / 1000) * 128);
		//*/
		case 448:
			FlxTween.tween(camBF.scroll, {x: 120}, (Conductor.stepCrochet / 1000) * 64);
			FlxTween.tween(boyfriend, {alpha: 1}, (Conductor.stepCrochet / 1000) * 8);
		case 512:
			FlxTween.tween(camGame.scroll, {x: 20, y: -210}, (Conductor.stepCrochet / 1000) * 8, {ease: FlxEase.circOut});
			FlxTween.tween(camBF.scroll, {x: 0, y: 0}, (Conductor.stepCrochet / 1000) * 8, {ease: FlxEase.circOut});
		case 640:
			if (FlxG.save.data.midsongvids_toggle) {
				energy.visible = true;
				FlxTween.tween(energy.scale, {x: 1.5, y: 1.5}, (Conductor.stepCrochet / 1000) * 12);
			}
		case 652:
			charBop = true;
			pattern.visible = true;

			if (FlxG.save.data.midsongvids_toggle) {
				remove(energy);
			}
		case 908:
			charBop = false;
			pattern.visible = false;
			camGame.scroll.y -= 70;
			camBF.scroll.y += 80;
			camGame.scroll.x += 250;
			camBF.scroll.x -= 100;
			boyfriend.alpha = 0.001;
			FlxTween.tween(camGame.scroll, {x: -200}, (Conductor.stepCrochet / 1000) * 128);
		case 972:
			FlxTween.tween(camBF.scroll, {x: 180}, (Conductor.stepCrochet / 1000) * 96);
			FlxTween.tween(boyfriend, {alpha: 1}, (Conductor.stepCrochet / 1000) * 8);
		case 1036:
			FlxTween.tween(camGame.scroll, {x: -1200}, (Conductor.stepCrochet / 1000) * 16, {ease: FlxEase.sineIn});
			FlxTween.tween(camGame, {angle: 30}, (Conductor.stepCrochet / 1000) * 16, {ease: FlxEase.quartIn});
		case 1044:
			camHUD.fade(FlxColor.BLACK, 2.1);
	}
}

function update(elapsed) {
	strumLines.members[0].characters[0].y = (FlxMath.lerp(dad.y, ogDADY, 0.08));
	strumLines.members[0].characters[1].y = (FlxMath.lerp(dad.y, ogDADY, 0.08));
	boyfriend.y = (FlxMath.lerp(boyfriend.y, ogBFY, 0.1));
	camBF.zoom = FlxG.camera.zoom;
}
